// Constants
const READER_BASE_URL = 'https://reading.twsp.app/reader';  // Update this with your actual domain

// DOM Elements
const postmarkAddress = document.getElementById('postmarkAddress');
const copyBtn = document.getElementById('copyBtn');
const emailInput = document.getElementById('emailInput');
const addEmailBtn = document.getElementById('addEmail');
const emailList = document.getElementById('emailList');
const openReaderBtn = document.getElementById('openReader');

// Initialize
document.addEventListener('DOMContentLoaded', async () => {
  await loadEmails();
});

// Copy address with button
copyBtn.addEventListener('click', async () => {
  try {
    await navigator.clipboard.writeText(postmarkAddress.textContent);
    const originalText = copyBtn.textContent;
    copyBtn.textContent = 'Copied!';
    setTimeout(() => {
      copyBtn.textContent = originalText;
    }, 1500);
  } catch (err) {
    console.error('Failed to copy:', err);
  }
});

// Add new email
addEmailBtn.addEventListener('click', async () => {
  const email = emailInput.value.trim();
  if (!email || !isValidEmail(email)) {
    alert('Please enter a valid email address');
    return;
  }

  const emails = await getStoredEmails();
  if (emails.includes(email)) {
    alert('This email is already added');
    return;
  }

  emails.push(email);
  await chrome.storage.sync.set({ emails });
  emailInput.value = '';
  await loadEmails();
});

// Open reader with all emails
openReaderBtn.addEventListener('click', async () => {
  const emails = await getStoredEmails();
  if (emails.length === 0) {
    alert('Please add at least one email address first');
    return;
  }

  const queryString = emails.join('+');
  const readerUrl = `${READER_BASE_URL}?email=${queryString}`;
  chrome.tabs.create({ url: readerUrl });
});

// Helper functions
async function getStoredEmails() {
  const result = await chrome.storage.sync.get('emails');
  return result.emails || [];
}

async function loadEmails() {
  const emails = await getStoredEmails();
  emailList.innerHTML = '';
  
  emails.forEach(email => {
    const div = document.createElement('div');
    div.className = 'email-item';
    
    const span = document.createElement('span');
    span.textContent = email;
    
    const removeBtn = document.createElement('button');
    removeBtn.className = 'remove-btn';
    removeBtn.textContent = 'Remove';
    removeBtn.onclick = async () => {
      const updatedEmails = emails.filter(e => e !== email);
      await chrome.storage.sync.set({ emails: updatedEmails });
      await loadEmails();
    };
    
    div.appendChild(span);
    div.appendChild(removeBtn);
    emailList.appendChild(div);
  });
}

function isValidEmail(email) {
  return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
} 